(* ::Package:: *)

(* ::Title:: *)
(*Integration Problems Involving Bessel Functions*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m BesselJ(n,a+b x)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form BesselJ[n, a+b x]*)


{BesselJ[7, a + b*x], x, 4, -(BesselJ[0, a + b*x]/b) - (2*BesselJ[2, a + b*x])/b - (2*BesselJ[4, a + b*x])/b - (2*BesselJ[6, a + b*x])/b}
{BesselJ[5, a + b*x], x, 3, -(BesselJ[0, a + b*x]/b) - (2*BesselJ[2, a + b*x])/b - (2*BesselJ[4, a + b*x])/b}
{BesselJ[3, a + b*x], x, 2, -(BesselJ[0, a + b*x]/b) - (2*BesselJ[2, a + b*x])/b}
{BesselJ[1, a + b*x], x, 1, -(BesselJ[0, a + b*x]/b)}
{BesselJ[-1, a + b*x], x, 1, BesselJ[0, a + b*x]/b}
{BesselJ[-3, a + b*x], x, 2, BesselJ[0, a + b*x]/b + (2*BesselJ[2, a + b*x])/b}
{BesselJ[-5, a + b*x], x, 3, BesselJ[0, a + b*x]/b + (2*BesselJ[2, a + b*x])/b + (2*BesselJ[4, a + b*x])/b}
{BesselJ[-7, a + b*x], x, 4, BesselJ[0, a + b*x]/b + (2*BesselJ[2, a + b*x])/b + (2*BesselJ[4, a + b*x])/b + (2*BesselJ[6, a + b*x])/b}

{BesselJ[4, a + b*x], x, 1, ((a + b*x)^5*HypergeometricPFQ[{5/2}, {7/2, 5}, (-(1/4))*(a + b*x)^2])/(1920*b)}
{BesselJ[2, a + b*x], x, 1, ((a + b*x)^3*HypergeometricPFQ[{3/2}, {5/2, 3}, (-(1/4))*(a + b*x)^2])/(24*b)}
{BesselJ[0, a + b*x], x, 1, ((a + b*x)*HypergeometricPFQ[{1/2}, {1, 3/2}, (-(1/4))*(a + b*x)^2])/b}
{BesselJ[-2, a + b*x], x, 1, ((a + b*x)^3*HypergeometricPFQ[{3/2}, {5/2, 3}, (-(1/4))*(a + b*x)^2])/(24*b)}
{BesselJ[-4, a + b*x], x, 1, ((a + b*x)^5*HypergeometricPFQ[{5/2}, {7/2, 5}, (-(1/4))*(a + b*x)^2])/(1920*b)}


(* ::Subsection::Closed:: *)
(*Integrands of the form BesselJ[n/2, a+b x]*)


{BesselJ[7/2, a + b*x], x, 18, (6*Sqrt[2/Pi]*Cos[a + b*x])/(b*(a + b*x)^(3/2)) + (2*FresnelC[Sqrt[2/Pi]*Sqrt[a + b*x]])/b - (6*Sqrt[2/Pi]*Sin[a + b*x])/(b*(a + b*x)^(5/2))}
{BesselJ[5/2, a + b*x], x, 12, (2*Sqrt[2/Pi]*Cos[a + b*x])/(b*Sqrt[a + b*x]) + (2*FresnelS[Sqrt[2/Pi]*Sqrt[a + b*x]])/b - (2*Sqrt[2/Pi]*Sin[a + b*x])/(b*(a + b*x)^(3/2))}
{BesselJ[3/2, a + b*x], x, 6, (2*FresnelC[Sqrt[2/Pi]*Sqrt[a + b*x]])/b - (2*Sqrt[2/Pi]*Sin[a + b*x])/(b*Sqrt[a + b*x])}
{BesselJ[1/2, a + b*x], x, 3, (2*FresnelS[Sqrt[2/Pi]*Sqrt[a + b*x]])/b}
{BesselJ[-1/2, a + b*x], x, 3, (2*FresnelC[Sqrt[2/Pi]*Sqrt[a + b*x]])/b}
{BesselJ[-3/2, a + b*x], x, 6, (2*Sqrt[2/Pi]*Cos[a + b*x])/(b*Sqrt[a + b*x]) + (2*FresnelS[Sqrt[2/Pi]*Sqrt[a + b*x]])/b}
{BesselJ[-5/2, a + b*x], x, 12, -((2*Sqrt[2/Pi]*Cos[a + b*x])/(b*(a + b*x)^(3/2))) + (2*FresnelC[Sqrt[2/Pi]*Sqrt[a + b*x]])/b - (2*Sqrt[2/Pi]*Sin[a + b*x])/(b*Sqrt[a + b*x])}
{BesselJ[-7/2, a + b*x], x, 18, (6*Sqrt[2/Pi]*Cos[a + b*x])/(b*(a + b*x)^(5/2)) + (2*FresnelS[Sqrt[2/Pi]*Sqrt[a + b*x]])/b + (6*Sqrt[2/Pi]*Sin[a + b*x])/(b*(a + b*x)^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form BesselJ[n, a+b x] when n symbolic*)


{BesselJ[n, a + b*x], x, 1, ((a + b*x)^(1 + n)*HypergeometricPFQ[{1/2 + n/2}, {3/2 + n/2, 1 + n}, (-(1/4))*(a + b*x)^2])/(2^n*(b*Gamma[2 + n]))}
